/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.ovr.OVRFovPort;
import org.lwjgl.ovr.OVRLayerHeader;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.ovr.OVRRecti;
import org.lwjgl.ovr.OVRTextureLayoutDescUnion;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrLayerEyeFovMultires")
public class OVRLayerEyeFovMultires
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEADER;
    public static final int COLORTEXTURE;
    public static final int VIEWPORT;
    public static final int FOV;
    public static final int RENDERPOSE;
    public static final int SENSORSAMPLETIME;
    public static final int TEXTURELAYOUT;
    public static final int TEXTURELAYOUTDESC;

    public OVRLayerEyeFovMultires(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRLayerEyeFovMultires.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrLayerHeader")
    public OVRLayerHeader Header() {
        return OVRLayerEyeFovMultires.nHeader(this.address());
    }

    @NativeType(value="ovrTextureSwapChain[ovrEye_Count]")
    public PointerBuffer ColorTexture() {
        return OVRLayerEyeFovMultires.nColorTexture(this.address());
    }

    @NativeType(value="ovrTextureSwapChain")
    public long ColorTexture(int index) {
        return OVRLayerEyeFovMultires.nColorTexture(this.address(), index);
    }

    @NativeType(value="ovrRecti[ovrEye_Count]")
    public OVRRecti.Buffer Viewport() {
        return OVRLayerEyeFovMultires.nViewport(this.address());
    }

    @NativeType(value="ovrRecti")
    public OVRRecti Viewport(int index) {
        return OVRLayerEyeFovMultires.nViewport(this.address(), index);
    }

    @NativeType(value="ovrFovPort[ovrEye_Count]")
    public OVRFovPort.Buffer Fov() {
        return OVRLayerEyeFovMultires.nFov(this.address());
    }

    @NativeType(value="ovrFovPort")
    public OVRFovPort Fov(int index) {
        return OVRLayerEyeFovMultires.nFov(this.address(), index);
    }

    @NativeType(value="ovrPosef[ovrEye_Count]")
    public OVRPosef.Buffer RenderPose() {
        return OVRLayerEyeFovMultires.nRenderPose(this.address());
    }

    @NativeType(value="ovrPosef")
    public OVRPosef RenderPose(int index) {
        return OVRLayerEyeFovMultires.nRenderPose(this.address(), index);
    }

    public double SensorSampleTime() {
        return OVRLayerEyeFovMultires.nSensorSampleTime(this.address());
    }

    @NativeType(value="ovrTextureLayout")
    public int TextureLayout() {
        return OVRLayerEyeFovMultires.nTextureLayout(this.address());
    }

    @NativeType(value="ovrTextureLayoutDesc_Union")
    public OVRTextureLayoutDescUnion TextureLayoutDesc() {
        return OVRLayerEyeFovMultires.nTextureLayoutDesc(this.address());
    }

    public OVRLayerEyeFovMultires Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
        OVRLayerEyeFovMultires.nHeader(this.address(), value);
        return this;
    }

    public OVRLayerEyeFovMultires Header(Consumer<OVRLayerHeader> consumer) {
        consumer.accept(this.Header());
        return this;
    }

    public OVRLayerEyeFovMultires ColorTexture(@NativeType(value="ovrTextureSwapChain[ovrEye_Count]") PointerBuffer value) {
        OVRLayerEyeFovMultires.nColorTexture(this.address(), value);
        return this;
    }

    public OVRLayerEyeFovMultires ColorTexture(int index, @NativeType(value="ovrTextureSwapChain") long value) {
        OVRLayerEyeFovMultires.nColorTexture(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeFovMultires Viewport(@NativeType(value="ovrRecti[ovrEye_Count]") OVRRecti.Buffer value) {
        OVRLayerEyeFovMultires.nViewport(this.address(), value);
        return this;
    }

    public OVRLayerEyeFovMultires Viewport(int index, @NativeType(value="ovrRecti") OVRRecti value) {
        OVRLayerEyeFovMultires.nViewport(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeFovMultires Viewport(Consumer<OVRRecti.Buffer> consumer) {
        consumer.accept(this.Viewport());
        return this;
    }

    public OVRLayerEyeFovMultires Viewport(int index, Consumer<OVRRecti> consumer) {
        consumer.accept(this.Viewport(index));
        return this;
    }

    public OVRLayerEyeFovMultires Fov(@NativeType(value="ovrFovPort[ovrEye_Count]") OVRFovPort.Buffer value) {
        OVRLayerEyeFovMultires.nFov(this.address(), value);
        return this;
    }

    public OVRLayerEyeFovMultires Fov(int index, @NativeType(value="ovrFovPort") OVRFovPort value) {
        OVRLayerEyeFovMultires.nFov(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeFovMultires Fov(Consumer<OVRFovPort.Buffer> consumer) {
        consumer.accept(this.Fov());
        return this;
    }

    public OVRLayerEyeFovMultires Fov(int index, Consumer<OVRFovPort> consumer) {
        consumer.accept(this.Fov(index));
        return this;
    }

    public OVRLayerEyeFovMultires RenderPose(@NativeType(value="ovrPosef[ovrEye_Count]") OVRPosef.Buffer value) {
        OVRLayerEyeFovMultires.nRenderPose(this.address(), value);
        return this;
    }

    public OVRLayerEyeFovMultires RenderPose(int index, @NativeType(value="ovrPosef") OVRPosef value) {
        OVRLayerEyeFovMultires.nRenderPose(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeFovMultires RenderPose(Consumer<OVRPosef.Buffer> consumer) {
        consumer.accept(this.RenderPose());
        return this;
    }

    public OVRLayerEyeFovMultires RenderPose(int index, Consumer<OVRPosef> consumer) {
        consumer.accept(this.RenderPose(index));
        return this;
    }

    public OVRLayerEyeFovMultires SensorSampleTime(double value) {
        OVRLayerEyeFovMultires.nSensorSampleTime(this.address(), value);
        return this;
    }

    public OVRLayerEyeFovMultires TextureLayout(@NativeType(value="ovrTextureLayout") int value) {
        OVRLayerEyeFovMultires.nTextureLayout(this.address(), value);
        return this;
    }

    public OVRLayerEyeFovMultires TextureLayoutDesc(@NativeType(value="ovrTextureLayoutDesc_Union") OVRTextureLayoutDescUnion value) {
        OVRLayerEyeFovMultires.nTextureLayoutDesc(this.address(), value);
        return this;
    }

    public OVRLayerEyeFovMultires TextureLayoutDesc(Consumer<OVRTextureLayoutDescUnion> consumer) {
        consumer.accept(this.TextureLayoutDesc());
        return this;
    }

    public OVRLayerEyeFovMultires set(OVRLayerHeader Header, PointerBuffer ColorTexture, OVRRecti.Buffer Viewport, OVRFovPort.Buffer Fov, OVRPosef.Buffer RenderPose, double SensorSampleTime, int TextureLayout, OVRTextureLayoutDescUnion TextureLayoutDesc) {
        this.Header(Header);
        this.ColorTexture(ColorTexture);
        this.Viewport(Viewport);
        this.Fov(Fov);
        this.RenderPose(RenderPose);
        this.SensorSampleTime(SensorSampleTime);
        this.TextureLayout(TextureLayout);
        this.TextureLayoutDesc(TextureLayoutDesc);
        return this;
    }

    public OVRLayerEyeFovMultires set(OVRLayerEyeFovMultires src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRLayerEyeFovMultires malloc() {
        return (OVRLayerEyeFovMultires)OVRLayerEyeFovMultires.wrap(OVRLayerEyeFovMultires.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRLayerEyeFovMultires calloc() {
        return (OVRLayerEyeFovMultires)OVRLayerEyeFovMultires.wrap(OVRLayerEyeFovMultires.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRLayerEyeFovMultires create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (OVRLayerEyeFovMultires)OVRLayerEyeFovMultires.wrap(OVRLayerEyeFovMultires.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static OVRLayerEyeFovMultires create(long address) {
        return (OVRLayerEyeFovMultires)OVRLayerEyeFovMultires.wrap(OVRLayerEyeFovMultires.class, (long)address);
    }

    @Nullable
    public static OVRLayerEyeFovMultires createSafe(long address) {
        return address == 0L ? null : (OVRLayerEyeFovMultires)OVRLayerEyeFovMultires.wrap(OVRLayerEyeFovMultires.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)OVRLayerEyeFovMultires.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)OVRLayerEyeFovMultires.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)OVRLayerEyeFovMultires.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRLayerEyeFovMultires.__create((int)capacity, (int)SIZEOF);
        return (Buffer)OVRLayerEyeFovMultires.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)OVRLayerEyeFovMultires.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)OVRLayerEyeFovMultires.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static OVRLayerEyeFovMultires mallocStack() {
        return OVRLayerEyeFovMultires.mallocStack(MemoryStack.stackGet());
    }

    public static OVRLayerEyeFovMultires callocStack() {
        return OVRLayerEyeFovMultires.callocStack(MemoryStack.stackGet());
    }

    public static OVRLayerEyeFovMultires mallocStack(MemoryStack stack) {
        return (OVRLayerEyeFovMultires)OVRLayerEyeFovMultires.wrap(OVRLayerEyeFovMultires.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRLayerEyeFovMultires callocStack(MemoryStack stack) {
        return (OVRLayerEyeFovMultires)OVRLayerEyeFovMultires.wrap(OVRLayerEyeFovMultires.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRLayerEyeFovMultires.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRLayerEyeFovMultires.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)OVRLayerEyeFovMultires.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)OVRLayerEyeFovMultires.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static OVRLayerHeader nHeader(long struct) {
        return OVRLayerHeader.create(struct + (long)HEADER);
    }

    public static PointerBuffer nColorTexture(long struct) {
        return MemoryUtil.memPointerBuffer((long)(struct + (long)COLORTEXTURE), (int)2);
    }

    public static long nColorTexture(long struct, int index) {
        return MemoryUtil.memGetAddress((long)(struct + (long)COLORTEXTURE + Checks.check((int)index, (int)2) * (long)POINTER_SIZE));
    }

    public static OVRRecti.Buffer nViewport(long struct) {
        return OVRRecti.create(struct + (long)VIEWPORT, 2);
    }

    public static OVRRecti nViewport(long struct, int index) {
        return OVRRecti.create(struct + (long)VIEWPORT + Checks.check((int)index, (int)2) * (long)OVRRecti.SIZEOF);
    }

    public static OVRFovPort.Buffer nFov(long struct) {
        return OVRFovPort.create(struct + (long)FOV, 2);
    }

    public static OVRFovPort nFov(long struct, int index) {
        return OVRFovPort.create(struct + (long)FOV + Checks.check((int)index, (int)2) * (long)OVRFovPort.SIZEOF);
    }

    public static OVRPosef.Buffer nRenderPose(long struct) {
        return OVRPosef.create(struct + (long)RENDERPOSE, 2);
    }

    public static OVRPosef nRenderPose(long struct, int index) {
        return OVRPosef.create(struct + (long)RENDERPOSE + Checks.check((int)index, (int)2) * (long)OVRPosef.SIZEOF);
    }

    public static double nSensorSampleTime(long struct) {
        return UNSAFE.getDouble(null, struct + (long)SENSORSAMPLETIME);
    }

    public static int nTextureLayout(long struct) {
        return UNSAFE.getInt(null, struct + (long)TEXTURELAYOUT);
    }

    public static OVRTextureLayoutDescUnion nTextureLayoutDesc(long struct) {
        return OVRTextureLayoutDescUnion.create(struct + (long)TEXTURELAYOUTDESC);
    }

    public static void nHeader(long struct, OVRLayerHeader value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)HEADER), (long)OVRLayerHeader.SIZEOF);
    }

    public static void nColorTexture(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((CustomBuffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((CustomBuffer)value), (long)(struct + (long)COLORTEXTURE), (long)(value.remaining() * POINTER_SIZE));
    }

    public static void nColorTexture(long struct, int index, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)COLORTEXTURE + Checks.check((int)index, (int)2) * (long)POINTER_SIZE), (long)value);
    }

    public static void nViewport(long struct, OVRRecti.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((CustomBuffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)VIEWPORT), (long)(value.remaining() * OVRRecti.SIZEOF));
    }

    public static void nViewport(long struct, int index, OVRRecti value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)VIEWPORT + Checks.check((int)index, (int)2) * (long)OVRRecti.SIZEOF), (long)OVRRecti.SIZEOF);
    }

    public static void nFov(long struct, OVRFovPort.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((CustomBuffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FOV), (long)(value.remaining() * OVRFovPort.SIZEOF));
    }

    public static void nFov(long struct, int index, OVRFovPort value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FOV + Checks.check((int)index, (int)2) * (long)OVRFovPort.SIZEOF), (long)OVRFovPort.SIZEOF);
    }

    public static void nRenderPose(long struct, OVRPosef.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((CustomBuffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)RENDERPOSE), (long)(value.remaining() * OVRPosef.SIZEOF));
    }

    public static void nRenderPose(long struct, int index, OVRPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)RENDERPOSE + Checks.check((int)index, (int)2) * (long)OVRPosef.SIZEOF), (long)OVRPosef.SIZEOF);
    }

    public static void nSensorSampleTime(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)SENSORSAMPLETIME, value);
    }

    public static void nTextureLayout(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TEXTURELAYOUT, value);
    }

    public static void nTextureLayoutDesc(long struct, OVRTextureLayoutDescUnion value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)TEXTURELAYOUTDESC), (long)OVRTextureLayoutDescUnion.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)COLORTEXTURE)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            OVRLayerEyeFovMultires.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = OVRLayerEyeFovMultires.__struct((Struct.Member[])new Struct.Member[]{OVRLayerEyeFovMultires.__member((int)OVRLayerHeader.SIZEOF, (int)OVRLayerHeader.ALIGNOF, (boolean)true), OVRLayerEyeFovMultires.__array((int)POINTER_SIZE, (int)2), OVRLayerEyeFovMultires.__array((int)OVRRecti.SIZEOF, (int)OVRRecti.ALIGNOF, (int)2), OVRLayerEyeFovMultires.__array((int)OVRFovPort.SIZEOF, (int)OVRFovPort.ALIGNOF, (int)2), OVRLayerEyeFovMultires.__array((int)OVRPosef.SIZEOF, (int)OVRPosef.ALIGNOF, (int)2), OVRLayerEyeFovMultires.__member((int)8), OVRLayerEyeFovMultires.__member((int)4), OVRLayerEyeFovMultires.__member((int)OVRTextureLayoutDescUnion.SIZEOF, (int)OVRTextureLayoutDescUnion.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEADER = layout.offsetof(0);
        COLORTEXTURE = layout.offsetof(1);
        VIEWPORT = layout.offsetof(2);
        FOV = layout.offsetof(3);
        RENDERPOSE = layout.offsetof(4);
        SENSORSAMPLETIME = layout.offsetof(5);
        TEXTURELAYOUT = layout.offsetof(6);
        TEXTURELAYOUTDESC = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<OVRLayerEyeFovMultires, Buffer>
    implements NativeResource {
        private static final OVRLayerEyeFovMultires ELEMENT_FACTORY = OVRLayerEyeFovMultires.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OVRLayerEyeFovMultires getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ovrLayerHeader")
        public OVRLayerHeader Header() {
            return OVRLayerEyeFovMultires.nHeader(this.address());
        }

        @NativeType(value="ovrTextureSwapChain[ovrEye_Count]")
        public PointerBuffer ColorTexture() {
            return OVRLayerEyeFovMultires.nColorTexture(this.address());
        }

        @NativeType(value="ovrTextureSwapChain")
        public long ColorTexture(int index) {
            return OVRLayerEyeFovMultires.nColorTexture(this.address(), index);
        }

        @NativeType(value="ovrRecti[ovrEye_Count]")
        public OVRRecti.Buffer Viewport() {
            return OVRLayerEyeFovMultires.nViewport(this.address());
        }

        @NativeType(value="ovrRecti")
        public OVRRecti Viewport(int index) {
            return OVRLayerEyeFovMultires.nViewport(this.address(), index);
        }

        @NativeType(value="ovrFovPort[ovrEye_Count]")
        public OVRFovPort.Buffer Fov() {
            return OVRLayerEyeFovMultires.nFov(this.address());
        }

        @NativeType(value="ovrFovPort")
        public OVRFovPort Fov(int index) {
            return OVRLayerEyeFovMultires.nFov(this.address(), index);
        }

        @NativeType(value="ovrPosef[ovrEye_Count]")
        public OVRPosef.Buffer RenderPose() {
            return OVRLayerEyeFovMultires.nRenderPose(this.address());
        }

        @NativeType(value="ovrPosef")
        public OVRPosef RenderPose(int index) {
            return OVRLayerEyeFovMultires.nRenderPose(this.address(), index);
        }

        public double SensorSampleTime() {
            return OVRLayerEyeFovMultires.nSensorSampleTime(this.address());
        }

        @NativeType(value="ovrTextureLayout")
        public int TextureLayout() {
            return OVRLayerEyeFovMultires.nTextureLayout(this.address());
        }

        @NativeType(value="ovrTextureLayoutDesc_Union")
        public OVRTextureLayoutDescUnion TextureLayoutDesc() {
            return OVRLayerEyeFovMultires.nTextureLayoutDesc(this.address());
        }

        public Buffer Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
            OVRLayerEyeFovMultires.nHeader(this.address(), value);
            return this;
        }

        public Buffer Header(Consumer<OVRLayerHeader> consumer) {
            consumer.accept(this.Header());
            return this;
        }

        public Buffer ColorTexture(@NativeType(value="ovrTextureSwapChain[ovrEye_Count]") PointerBuffer value) {
            OVRLayerEyeFovMultires.nColorTexture(this.address(), value);
            return this;
        }

        public Buffer ColorTexture(int index, @NativeType(value="ovrTextureSwapChain") long value) {
            OVRLayerEyeFovMultires.nColorTexture(this.address(), index, value);
            return this;
        }

        public Buffer Viewport(@NativeType(value="ovrRecti[ovrEye_Count]") OVRRecti.Buffer value) {
            OVRLayerEyeFovMultires.nViewport(this.address(), value);
            return this;
        }

        public Buffer Viewport(int index, @NativeType(value="ovrRecti") OVRRecti value) {
            OVRLayerEyeFovMultires.nViewport(this.address(), index, value);
            return this;
        }

        public Buffer Viewport(Consumer<OVRRecti.Buffer> consumer) {
            consumer.accept(this.Viewport());
            return this;
        }

        public Buffer Viewport(int index, Consumer<OVRRecti> consumer) {
            consumer.accept(this.Viewport(index));
            return this;
        }

        public Buffer Fov(@NativeType(value="ovrFovPort[ovrEye_Count]") OVRFovPort.Buffer value) {
            OVRLayerEyeFovMultires.nFov(this.address(), value);
            return this;
        }

        public Buffer Fov(int index, @NativeType(value="ovrFovPort") OVRFovPort value) {
            OVRLayerEyeFovMultires.nFov(this.address(), index, value);
            return this;
        }

        public Buffer Fov(Consumer<OVRFovPort.Buffer> consumer) {
            consumer.accept(this.Fov());
            return this;
        }

        public Buffer Fov(int index, Consumer<OVRFovPort> consumer) {
            consumer.accept(this.Fov(index));
            return this;
        }

        public Buffer RenderPose(@NativeType(value="ovrPosef[ovrEye_Count]") OVRPosef.Buffer value) {
            OVRLayerEyeFovMultires.nRenderPose(this.address(), value);
            return this;
        }

        public Buffer RenderPose(int index, @NativeType(value="ovrPosef") OVRPosef value) {
            OVRLayerEyeFovMultires.nRenderPose(this.address(), index, value);
            return this;
        }

        public Buffer RenderPose(Consumer<OVRPosef.Buffer> consumer) {
            consumer.accept(this.RenderPose());
            return this;
        }

        public Buffer RenderPose(int index, Consumer<OVRPosef> consumer) {
            consumer.accept(this.RenderPose(index));
            return this;
        }

        public Buffer SensorSampleTime(double value) {
            OVRLayerEyeFovMultires.nSensorSampleTime(this.address(), value);
            return this;
        }

        public Buffer TextureLayout(@NativeType(value="ovrTextureLayout") int value) {
            OVRLayerEyeFovMultires.nTextureLayout(this.address(), value);
            return this;
        }

        public Buffer TextureLayoutDesc(@NativeType(value="ovrTextureLayoutDesc_Union") OVRTextureLayoutDescUnion value) {
            OVRLayerEyeFovMultires.nTextureLayoutDesc(this.address(), value);
            return this;
        }

        public Buffer TextureLayoutDesc(Consumer<OVRTextureLayoutDescUnion> consumer) {
            consumer.accept(this.TextureLayoutDesc());
            return this;
        }
    }
}

